-- Su-27P1M by Currenthill

-- ==============================================================================================================

local function BD3(clsid)
	return {CLSID = clsid, arg_value = 0.15 }
end

local function MBD(clsid)
	return {CLSID = clsid, arg_value = 0.25 }
end


Su27P1M = {
    Name             = 'CH_Su-27P1M',
    DisplayName      = _('[CH] Su-27P1M'),
    EmptyWeight 	 = "17500",
    MaxFuelWeight 	 = "9400",
    MaxHeight 		 = "18500",
    MaxSpeed 		 = "2500",
    MaxTakeOffWeight = "33000",
    Picture 		 = "Su-27.png",
    Rate 			 = "50",
    Shape            = 'Su-27P1M',
    shape_table_data = {
        {
            file        = 'Su-27P1M',
            life        = 30,  
            vis         = 3,  
            desrt       = 'mig-29-oblomok', 
            fire        = {300, 2},  
            username    = 'Su-27P1M',
            index       = WSTYPE_PLACEHOLDER,
            classname   = "lLandPlane",
            positioning = "BYNORMAL",
        },
        {
            name = "mig-29-oblomok",
            file = "mig-29-oblomok",
            fire = {240, 2},
        },
    },

    mapclasskey          = "P0091000024",
    WorldID              = WSTYPE_PLACEHOLDER,
    attribute            = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Fighters", "Datalink"},
    Categories           = {},
    Countries            = {'Ukraine'},
    country_of_origin    = 'UKR',
    date_of_introduction = 2015.1,

    net_animation =
    {
    },

    ColdStartDefaultControls = {
    },

    AddPropAircraft = {
    },

-- ==============================================================================================================

    M_empty                     = 17500.0,   	-- pilot and nose load, kg
    M_nominal                   = 20000.0,  	-- (Empty Plus Full Internal Fuel)
    M_max                       = 28000.0,  	-- (Maximum Take Off Weight)
    M_fuel_max                  = 9400.0,   	-- (Internal Fuel Only)
    H_max                       = 18500.0,   	-- (Maximum Operational Ceiling)
    average_fuel_consumption    = 0.268,    
    CAS_min                     = 58,        
    V_opt                       = 170,    	 
    V_take_off                  = 75.0,      	-- Take off speed in m/s (for AI)
    V_land                      = 65.0,      	-- Land speed in m/s (for AI)
    V_max_sea_level             = 403,     		-- Max speed at sea level in m/s (for AI)
    V_max_h                     = 694.44,     	-- Max speed at max altitude in m/s (for AI)
    Vy_max                      = 325,     		-- Max climb speed in m/s (for AI)
    Mach_max                    = 2.35,      	-- Max speed in Mach (for AI)
    Ny_min                      = -3,         	-- Min G (for AI)
    Ny_max                      = 8,	       	-- Max G (for AI)
    Ny_max_e                    = 3,         	-- Max G (for AI)
    AOA_take_off                = 0.17,      	-- AoA in take off (for AI)
    bank_angle_max              = 60,        	-- Max bank angle (for AI)
    has_afteburner              = true,     	-- AFB yes/no
    has_speedbrake              = true,     	-- Speedbrake yes/no
    has_differential_stabilizer = false,
	bigParkingRamp 				= false,	
    singleInFlight 				= false,
    undercarriage_movement 		= 2,	

-- ==============================================================================================================

	nose_gear_pos = 	{5.221,	-2.185,	0},
	main_gear_pos = 	{-0.537,-2.237,	2.168},
	nose_gear_amortizer_direct_stroke    =  2.289 - 2.185,  -- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke  =  1.992 - 2.185,  -- up 
	main_gear_amortizer_direct_stroke	 =  2.555 - 2.237, --  down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke  = 	2.123 - 2.237, --  up 
	nose_gear_amortizer_normal_weight_stroke = -0.00311633945,-- down from nose_gear_pos
	main_gear_amortizer_normal_weight_stroke =  0.0986220837,-- down from main_gear_pos
	
-- ==============================================================================================================

    brakeshute_name           = 4,        			-- Landing - brake chute visual shape after separation

    wing_tip_pos              = {-4.5, 0.4, 7.5}, 	-- wingtip coords for visual effects
    wing_area                 = 62,        			-- wing area in m2
    wing_span                 = 14.7,        		-- wing spain in m,
    wing_type                 = 1,        			-- Fixed wing
    flaps_maneuver            = 1.0,        		-- Max flaps in take-off and maneuver (0.5 = 1st stage, 1.0 = 2nd stage) (for AI)

    thrust_sum_max            = 15200,
    thrust_sum_ab             = 25000,

    length                    = 21.935,    		-- full lenght in m
    height                    = 5.932,        	-- height in m
    range                     = 3740,        	-- Max range in km (for AI)
    RCS                       = 5.5,       		-- Radar Cross Section m2
    IR_emission_coeff         = 1,        		-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
    IR_emission_coeff_ab      = 5.0,        	-- With afterburner

	engines_count = 2,
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-6.889,	-0.257,	-1.193},
				elevation	=	0,
				diameter	=	1.137,
				exhaust_length_ab	=	8.6,
				exhaust_length_ab_K	=	0.629,
				smokiness_level     = 	0.1, 
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-6.889,	-0.257,	1.193},
				elevation	=	0,
				diameter	=	1.137,
				exhaust_length_ab	=	8.6,
				exhaust_length_ab_K	=	0.629,
				smokiness_level     = 	0.1, 
			}, -- end of [2]
		}, -- end of engines_nozzles
		
-- ==============================================================================================================
 
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name	=	9,
			drop_canopy_name	=	35,
			pos = 	{7.916,	0.986,	0},
		}, -- end of [1]
	}, -- end of crew_members

-- ==============================================================================================================

	mechanimations = {
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0.11, "at", 0.074, "sign", 2 } }
					}, {
						C = { { "Arg", 38, "to", 0.9, "at", 0.14 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "at", 0.18 } }
					}, {
						C = { { "Arg", 38, "to", 0.89, "at", 0.074, "sign", -2 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "JettisonCanopy", 0 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		HeadLights = { {
				Sequence = { {
						C = { { "Arg", 208, "set", 0 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0 } }
					} },
				Transition = { "Any", "Off" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0.5 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 1 } }
					} },
				Transition = { "Any", "High" }
			} },
		LeftStrut = {        
				{
					Transition = {"Retract", "Extend"},                  
					Sequence = {
						{C = {{"Arg", 116, "to", 1.0, "in", 4.0, "sign", 1}}},  
						{C = {{"Arg",  5, "to", 1.0, "in", 6.0, "sign", 1}}},   
					},
					Flags = {"Reversible"},
				},
				{
					Transition = {"Extend", "Retract"},                     
					Sequence = {
						{C = {{"Arg",  5, "to", 0.0, "in", 6.0, "sign", -1}}},  
						{C = {{"Arg", 116, "to", 0.0, "in", 4.0, "sign", -1}}}, 
					},
					Flags = {"Reversible"},
				},
				}, 
			RightStrut = {
				{
					Transition = {"Retract", "Extend"},
					Sequence = {
						{C = {{"Arg", 115, "to", 1.0, "in", 4.0, "sign", 1}}},
						{C = {{"Arg", 3, "to", 1.0, "in", 6.0, "sign", 1}}},  
					},
					Flags = {"Reversible"},
				},
				{
					Transition = {"Extend", "Retract"},
					Sequence = {
						{C = {{"Arg", 3, "to", 0.0, "in", 6.0, "sign", -1}}},  
						{C = {{"Arg", 115, "to", 0.0, "in", 4.0, "sign", -1}}},
					},
					Flags = {"Reversible"},
				},
			},
			CentralStrut = {
				{
					Transition = {"Retract", "Extend"},
					Sequence = {
						{C = {{"Arg", 117, "to", 1.0, "in", 4.0, "sign", 1}}},  				
						{C = {{"Arg", 0, "to",  1.0, "in", 6.0, "sign", 1}}},   
					},
					Flags = {"Reversible"},
				},
				{
					Transition = {"Extend", "Retract"}, 
					Sequence = {						
						{C = {{"Arg", 0, "to", 0.0 , "in", 6.0, "sign", -1}}}, 
						{C = {{"Arg", 117, "to", 0.0, "in", 4.0, "sign", -1}}},					
					},
					Flags = {"Reversible"},
				},
			},			
	},

-- ==============================================================================================================

	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 192,
		chaff = {
			chargeSz = 1,
			default = 96,
			increment = 3
		},
		flare = {
			chargeSz = 1,
			default = 96,
			increment = 3
		}
	},

	chaff_flare_dispenser = { {
			dir = { 0, 1, 0 },
			pos = { -5.776, 1.4, -0.422 }
		}, {
			dir = { 0, 1, 0 },
			pos = { -5.776, 1.4, 0.422 }
		} },

    --sensors
	Sensors = {
		IRST = "OLS-27",
		RADAR = "Su-27P1M N-001-U1",
		RWR = "Abstract RWR"
	},
	
    detection_range_max   = 250,
    radar_can_see_ground  = true,
    EPLRS                 = true,
	
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),

-- ==============================================================================================================
	
	Pylons =     {	
    pylon(1, 0, -1.943000, 0.173000, -7.280000,
            {
				arg = 308 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" }, --R-73			
            }
        ),
        pylon(2, 0, -2.535000, -0.165000, -6.168000,
            {
				arg = 309 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" }, --R-73
				{ CLSID = "<CLEAN>", arg_value = 1 },					
            }
        ),
        pylon(3, 0, -1.137000, -0.321000, -4.524000,
            {
				arg = 310 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" , arg_value = 0.3}, --R-73
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}" }, --R-27ER
                { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}" }, --R-27ET
                BD3("B-8M1 - 20 S-8OFP2"),--B-8M1 - 20 S-8OFP2
                BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"),--FAB-250
                BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"),--FAB-500 M62
                BD3("{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"), --B-8M1 - 20 S-8KOM
                BD3("{FC56DF80-9B09-44C5-8976-DCFAFF219062}"), --B-13L - 5 S-13 OF
                BD3("{3DFB7320-AB0E-11d7-9897-000476191836}"), --B-8M1 - 20 S-8TsM
				MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),	--MER 6*6 FAB-100
				MBD("{53BE25A4-C86C-4571-9BC0-47D668349595}"),	--MER 6*6 FAB-250
				{ CLSID = "{TWIN_B13L_5OF}" 		, arg_value = 1},	--2* B-13L - 5 S-13 OF
				{ CLSID = "{TWIN_B_8M1_S_8KOM}" 	, arg_value = 1},	--2* B-8M1 - 20 S-8KOM
				{ CLSID = "{TWIN_B_8M1_S_8TsM}" 	, arg_value = 1},	--2* B-8M1 - 20 S-8TsM
				{ CLSID = "{TWIN_B_8M1_S_8_OFP2}"	, arg_value = 1 },	--2* B-8M1 - 20 S-8OFP2
				{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
				{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.0 },--ADM-160B x3					
				{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.0 },-- AGM-88C
				{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.15, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83	
				{ CLSID = "<CLEAN>", arg_value = 1 },	
				{ CLSID = "{CH_AASM250}", arg_value = 0.15, Type = 1 },--AASM 250					
	        }
        ),
        pylon(4, 1, -0.075000, -1.218000, -1.192000,
            {
				arg = 311 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}" }, --R-27ER
                BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"), --FAB-250
                BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"), --FAB-500 M62
				MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),	--MER 6*6 FAB-100
				MBD("{MBD3_U6_5*FAB-250}"),						--MER 6*5 FAB-250
				{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
				{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.0 },--ADM-160B x3					
				{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.0 },-- AGM-88C
				{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.15, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83		
				{ CLSID = "<CLEAN>", arg_value = 1 },	
				{ CLSID = "{CH_AASM250}", arg_value = 0.15, Type = 1 },--AASM 250				
            }
        ),
        pylon(5, 1, -3.751000, -0.384000, 0.000000,
            {
				arg = 312 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}" }, --R-27ER
                BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"), --FAB-250
                BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"), --FAB-500 M62
				MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),	--MER*6 FAB-100
				MBD("{MBD3_U6_3*FAB-250_fwd}"),					--MER*3 FAB-250
				{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
				{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.0 },--ADM-160B x3					
				{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.15, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83		
				{ CLSID = "<CLEAN>", arg_value = 1 },	
				{ CLSID = "{CH_AASM250}", arg_value = 0.15, Type = 1 },--AASM 250					
            }
        ),
        pylon(6, 1, 0.986000, -0.384000, 0.000000,
            {
				arg = 313 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}" }, --R-27ER
                BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"), --FAB-250
                BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"), --FAB-500 M62
				MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER 6*6 FAB-100
				MBD("{53BE25A4-C86C-4571-9BC0-47D668349595}"),--MER 6*6 FAB-250
				{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
				{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.0 },--ADM-160B x3					
				{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.15, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83		
				{ CLSID = "<CLEAN>", arg_value = 1 },		
				{ CLSID = "{CH_AASM250}", arg_value = 0.15, Type = 1 },--AASM 250					
            }
        ),
        pylon(7, 1, -0.075000, -1.218000, 1.192000,
            {
				arg = 314 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}" }, --R-27ER
                BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"), --FAB-250
                BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"), --FAB-500 M62
				MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),	--MER 6*6 FAB-100
				MBD("{MBD3_U6_5*FAB-250}"),						--MER 6*5 FAB-250
				{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
				{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.0 },--ADM-160B x3					
				{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.0 },-- AGM-88C
				{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.15, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83		
				{ CLSID = "<CLEAN>", arg_value = 1 },		
				{ CLSID = "{CH_AASM250}", arg_value = 0.15, Type = 1 },--AASM 250						
            }
        ),
        pylon(8, 0, -1.137000, -0.321000, 4.524000,
            {
				arg = 315 ,arg_value = 0,
				use_full_connector_position = true,
			},
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" , arg_value = 0.3}, --R-73
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}" }, --R-27ER
                { CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}" }, --R-27ET
                BD3("B-8M1 - 20 S-8OFP2"),--B-8M1 - 20 S-8OFP2
                BD3("{3C612111-C7AD-476E-8A8E-2485812F4E5C}"), --FAB-250
                BD3("{37DCC01E-9E02-432F-B61D-10C166CA2798}"), --FAB-500 M62
                BD3("{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"), --B-8M1 - 20 S-8KOM
                BD3("{FC56DF80-9B09-44C5-8976-DCFAFF219062}"), --B-13L - 5 S-13 OF
                BD3("{3DFB7320-AB0E-11d7-9897-000476191836}"), --B-8M1 - 20 S-8TsM
				MBD("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"),--MER*6 FAB-100
				MBD("{53BE25A4-C86C-4571-9BC0-47D668349595}"),--MER 6*6 FAB-250
				{ CLSID = "{TWIN_B13L_5OF}" 		, arg_value = 1},	--2* B-13L - 5 S-13 OF
				{ CLSID = "{TWIN_B_8M1_S_8KOM}" 	, arg_value = 1},	--2* B-8M1 - 20 S-8KOM
				{ CLSID = "{TWIN_B_8M1_S_8TsM}" 	, arg_value = 1},	--2* B-8M1 - 20 S-8TsM
				{ CLSID = "{TWIN_B_8M1_S_8_OFP2}"	, arg_value = 1 },	--2* B-8M1 - 20 S-8OFP2
				{ CLSID = "{MiG-29MU2_ADM-160B_LAU118}", arg_value = 0.0, Type = 1 },--ADM-160B	
				{ CLSID = "{MIG29MU2_BRU_42A_x3_ADM_160B}", Type = 1, arg_value = 0.0 },--ADM-160B x3					
				{ CLSID = "{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", arg_value = 0.0 },-- AGM-88C
				{ CLSID = "{MIG29MU2_JDAM-ER}", arg_value = 0.15, attach_point_position = {-0.05, 0.03, 0.0}, Type = 1 },--JDAM-ER Mk83	
				{ CLSID = "<CLEAN>", arg_value = 1 },					
				{ CLSID = "{CH_AASM250}", arg_value = 0.15, Type = 1 },--AASM 250					
            }
        ),
        pylon(9, 0, -2.535000, -0.165000, 6.168000,
            {
				arg = 316 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" }, --R-73
				{ CLSID = "<CLEAN>", arg_value = 1 },	
            }
        ),
        pylon(10, 0, -1.943000, 0.173000, 7.280000,
            {
				arg = 317 ,arg_value = 0,
				use_full_connector_position = true,
            },
            {
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" }, --R-73		
            }
        ),

	},

	Tasks = {
        aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
        aircraft_task(AFAC),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
        aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(CAP),

-- ==============================================================================================================

	SFM_Data = {
		aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx = 2.7,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.0268,
			cx_flap = 0.063,
			cy_flap = 0.42,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0.0,	0.0165,		0.077,		0.1,		0.032,		0.65,	25.0,	1.6,	},
				{0.2,	0.0165,		0.077,		0.1,		0.032,		1.95,	25.0,	1.6,	},
				{0.4,	0.0165,		0.077,		0.1,	   	0.032,		3.25,	25.0,	1.6,	},
				{0.6,	0.0165,		0.080,		0.094,		0.043,		4.55,	24.0,	1.5,	},
				{0.7,	0.0170,		0.083,		0.094,		0.045,		4.55,	23.0,	1.45,	},
				{0.8,	0.0178,		0.087,		0.094,		0.048,		4.55,	21.0,	1.4,    },
				{0.9,	0.0215,		0.091,		0.11,		0.050,		4.55,	20.0,	1.3,    },
				{1.0,	0.0310,		0.094,		0.15,		0.1,		4.55,	18.0,	1.2,    },
				{1.1,	0.0422,		0.094,	   	0.15,		0.1,		4.10,	16.0,	1.1,	},
				{1.2,	0.0440,		0.091,	   	0.14,		0.1,		3.19,	17.0,	1.05,	},		
				{1.3,	0.0432,		0.085,	   	0.17,		0.096,		2.28,	15.0,	1.0,	},					
				{1.5,	0.0423,		0.068,	   	0.23,		0.09,		1.95,	13.0,	0.9,	},					
				{1.8,	0.0416,		0.051,	   	0.23,		0.38,		1.17,	12.0,	0.7,	},					
				{2.0,	0.0416,		0.043,	   	0.08,		2.5,		1.04,	10.5,	0.55,	},		
				{2.2,	0.0416,		0.037,	   	0.16,		3.2,		0.91,	 9.0,	0.4,	},					
				{2.5,	0.0410,		0.036,		0.25,		4.5,		0.91,	 9.0,	0.4,	},		
				{3.9,	0.0395,		0.033,		0.35,		6.0,		0.8,	 9.0,	0.4		},				
			}
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	60.00001,--67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.5,
			dcx_eng	=	0.0124,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	8000,
			dpdh_f	=	17000.0,
			table_data = {
			--   M		Pmax		 Pfor
					{0,		126000,	185024},
				 	{0.2,	126000,	198744},
				 	{0.4,	126000,	208250},
				 	{0.6,	126000,	220892},
				 	{0.7,	124000,	226870},
				 	{0.8,	124000,	232887},
				 	{0.9,	122000,	250210},
				 	{1,		117000,	256120},
				 	{1.1,	113000,	265400},
				 	{1.2,	110000,	280300},
				 	{1.3,	102000,	298900},
				 	{1.5,	85000,	326000},
				 	{1.8,	30000,	350000},
				 	{2,		19000,	363000},
				 	{2.2,	17000,	384000},
				 	{2.5,	12000,	415000},
				 	{3.9,	10000,	260476},
				},
		}, -- end of engine 
	},	

-- ==============================================================================================================

	fires_pos = 
	{
		[1] = 	{-1.594,	-0.064,	0},
		[2] = 	{-1.073,	0.319,	3.716},
		[3] = 	{-1.187,	0.338,	-3.678},
		[4] = 	{-0.82,	0.265,	2.774},
		[5] = 	{-0.82,	0.265,	-2.774},
		[6] = 	{-0.82,	0.255,	3.260},
		[7] = 	{-0.82,	0.255,	-3.080},
		[8] = 	{-5.889,	-0.257,	1.193},
		[9] = 	{-5.889,	-0.257,	-1.193},
		[10] = 	{-1.257,	0.283,	3.05},
		[11] = 	{-1.257,	0.283,	-2.50},
	}, -- end of fires_pos
	
	Damage = { {
			args = { 296 },
			critical_damage = 3
		}, {
			args = { 297 },
			critical_damage = 3
		}, {
			args = { 65 },
			critical_damage = 8
		}, {
			args = { 298 },
			critical_damage = 2
		}, {
			args = { 301 },
			critical_damage = 2
		},
		[0] = {
			args = { 146 },
			critical_damage = 5
		},
		[7] = {
			args = { 249 },
			critical_damage = 2
		},
		[8] = {
			args = { 265 },
			critical_damage = 2
		},
		[9] = {
			args = { 154 },
			critical_damage = 3
		},
		[10] = {
			args = { 153 },
			critical_damage = 3
		},
		[11] = {
			args = { 167 },
			critical_damage = 1
		},
		[12] = {
			args = { 161 },
			critical_damage = 1
		},
		[13] = {
			args = { 169 },
			critical_damage = 2
		},
		[14] = {
			args = { 163 },
			critical_damage = 2
		},
		[15] = {
			args = { 267 },
			critical_damage = 2
		},
		[16] = {
			args = { 266 },
			critical_damage = 2
		},
		[17] = {
			args = { 168 },
			critical_damage = 2
		},
		[18] = {
			args = { 162 },
			critical_damage = 2
		},
		[20] = {
			args = { 183 },
			critical_damage = 1
		},
		[23] = {
			args = { 223 },
			critical_damage = 5
		},
		[24] = {
			args = { 213 },
			critical_damage = 5
		},
		[27] = {
			args = { 231 },
			critical_damage = 3
		},
		[28] = {
			args = { 221 },
			critical_damage = 3
		},
		[29] = {
			args = { 224 },
			critical_damage = 6,
			deps_cells = { 23 }
		},
		[30] = {
			args = { 214 },
			critical_damage = 6,
			deps_cells = { 24 }
		},
		[35] = {
			args = { 225 },
			critical_damage = 6,
			deps_cells = { 23, 29, 27, 37 }
		},
		[36] = {
			args = { 215 },
			critical_damage = 6,
			deps_cells = { 24, 30, 28, 38 }
		},
		[37] = {
			args = { 228 },
			critical_damage = 2
		},
		[38] = {
			args = { 218 },
			critical_damage = 2
		},
		[39] = {
			args = { 244 },
			critical_damage = 2
		},
		[40] = {
			args = { 241 },
			critical_damage = 2
		},
		[43] = {
			args = { 243 },
			critical_damage = 2,
			deps_cells = { 39, 53 }
		},
		[44] = {
			args = { 242 },
			critical_damage = 2,
			deps_cells = { 40, 54 }
		},
		[51] = {
			args = { 240 },
			critical_damage = 2
		},
		[52] = {
			args = { 238 },
			critical_damage = 2
		},
		[53] = {
			args = { 248 },
			critical_damage = 2
		},
		[54] = {
			args = { 247 },
			critical_damage = 2
		},
		[55] = {
			args = { 159 },
			critical_damage = 2
		},
		[58] = {
			args = { 156 },
			critical_damage = 2
		},
		[59] = {
			args = { 148 },
			critical_damage = 2
		},
		[82] = {
			args = { 152 },
			critical_damage = 2
		},
		[83] = {
			args = { 134 },
			critical_damage = 3
		},
		[84] = {
			args = { 136 },
			critical_damage = 3
		},
		[85] = {
			args = { 135 },
			critical_damage = 3
		}
	},		
			
    DamageParts =
    {
        [1] = "SU-27-OBLOMOK-WING-R",
        [2] = "SU-27-OBLOMOK-WING-L",
    },

    Failures = {
    },

-- ==============================================================================================================

	lights_data = {
		lights = {
			[3] = {
				lights = { {
						argument = 192,
						typename = "argumentlight"
					}, {
						argument = 190,
						typename = "argumentlight"
					}, {
						argument = 191,
						typename = "argumentlight"
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},
}

add_aircraft(Su27P1M)
